<?php
    // "myTube" YouTube downloader and mpeg converter
    // by Kenneth "Shrimp" Watson -- http://shrimpworks.za.net/
    // October 2006

    // adjust the default timeout if you need to.
    // PHP's default is 30 seconds, here we have it set to 5 minutes.
    // this is to allow the script time to complete downloading and 
    // converting the video.
	set_time_limit(300);

    // function to pass the converted mpegs to the client, with nice headers and all.
    function pushFile($file)
    {
        $fp = fopen($file, 'rb');
        header("Content-Type: video/mpeg");
        header("Content-Length: " . filesize($file));
        header('Content-Disposition: attachment; filename="'. basename($file) . '"');
        fpassthru($fp);
        fclose($fp);
    }

    // after downloading, the client needs to be told the download is ready, and also that
    // it can stop the little loading animation. unfortunately it only responds properly
    // when receiving an html file, as we use hax.
    function requestFile($slug)
    {
        echo '<html><head>';
        echo '<meta http-equiv="refresh" content="0;url='.basename(__FILE__).'?fetch='.$slug.'">';
        echo '</head><body>'.$slug.'</body></html>';
    }

    if (isset($_GET['fetch']))
    {
        // a specific, existing video has been requested, send it along
        pushFile(dirname(__FILE__) . '/archive/' . $_GET['fetch'] . '.mpeg');
    }
    else
    {
        // rip the youtube video id from the requested URL
        preg_match('#v=([A-Za-z0-9_\-]+)#', $_GET['url'], $vId);
        $vId = $vId[1];

        // first, lets grab the video's title... request only the first bit of the page, 
        // just enough to be sure the title arrives.
        $titleRes = file_get_contents('http://www.youtube.com/watch?v='.$vId, false, null, 0, 512);
        preg_match('#<title>YouTube - (.+?)</title>#', $titleRes, $title);
        $title = $title[1];

        // youtube default title returned, meaning video not found.
        // no client action is actually taken, so the user is left wondering WTF after
        // it silently fails :D
        if ($title == 'Broadcast Yourself.')
        {
            echo 'Video not found!';
        }
        else
        {
            // get only the alpha-numeric characters of the title, broken into words,
            // and construct a 'slug' for this video, ie: My_Cool_Clip_[teh-vid-id]
            preg_match_all('#([A-Za-z0-9]+)#', $title, $slugBits);
            $slug = implode('_', $slugBits[1]) . '_[' . $vId . ']';
            $destFile = dirname(__FILE__) . '/archive/' . $slug . '.mpeg';

            // if it already exists, just send the existing one, no need to download again.
            if (file_exists($destFile))
            {
                requestFile($slug);
            }
            else
            {
                // set up a temporary path, and save the flv file, which we will convert
                $tVid = '/tmp/mytube-'.$vId;
                $res = exec('python ' . dirname(__FILE__) . '/youtube-dl.py -o '.$tVid.'.flv "http://www.youtube.com/watch?v='.$vId.'"');

                // if it saved ...
                if (strpos($res, 'saved') !== false)
                {
                    // ... use ffmpeg to convert it to mpeg format
                    $nextRes = exec('ffmpeg -i '.$tVid.'.flv -ab 56 -ar 22050 -b 500 -s 320x240 '.$tVid.'.mpeg');

                    // and if it converted ...
                    if (file_exists($tVid.'.mpeg'))
                    {
                        // ... clean up ...
                        rename($tVid.'.mpeg', $destFile);
                        unlink($tVid.'.flv');

                        // ... add to the index for later downloading ...
                        $fi = fopen(dirname(__FILE__) . '/archive/index', 'a');
                        fwrite($fi, $slug . "\t" . $title . "\t" . time() . "\n");
                        fclose($fi);

                        // ... and send it to the client.
                        requestFile($slug);
                    }
                    else
                    {
                        echo "Failed to convert the video!<br /><br />" . $nextRes;
                    }
                }
                else
                    echo "Failed to download the video!<br /><br />" . $res;
            }
        }
    }
?>