<?php
    // "Nice Image Browser" simple image gallery script
    // by Kenneth "Shrimp" Watson -- http://shrimpworks.za.net/
    // May 2006

    // place this file in a directory with your images, and it'll 
    // generate a page of thumbnails and links to subdirectories
    // to create a very basic gallery type thing, without the need
    // for databases and all sorts of other stuff.

    // depends on the _nib_thumb.php basic thumbnail script.

	include('_nib_config.php');
?>
<html>
<head>
<title>Nice Image Browser</title>
<script>
	function selectGallery(gal)
	{
		location = '?'+gal;
	}

    var origScale = -1;
    function niceScale(img)
    {
        if (origScale == -1)
        {
            document.getElementById('imageTitle').innerHTML = document.getElementById('imageTitle').innerHTML + ' (' + img.width + ' x ' + img.height + ')';
            origScale = img.width;
        }

        if (img.width > document.body.clientWidth)
        {
            img.width = (document.body.clientWidth / 100) * 90;
            img.style.cursor = 'pointer';
        }
        else
            img.width = origScale;
    }
</script>
<style>
  <!--
	body {
		font-family: "Verdana";
		font-size: 10pt;
		margin: 0px;
        margin-bottom: 10px;
	}

    form {
        margin: 0px;
        padding: 0px;
    }

	.top {
		border: solid #5f5f5f;
		border-width: 1px;
		background-color: #bbb;
        padding: 10px;
	}

    .image {
        text-align: center;
        margin: 20px;
    }

    .image img {
		border: 1px solid #5f5f5f;
        border-top: 0px;
    }

    .imageTitle {
		font-weight: bold;
		background-color: #eee;
		color: black;
		padding: 5px;
		border: 1px solid #5f5f5f;
        width: 100%;
    }

	.gallery {
        margin: 5%;
		margin-top: 20px;
		margin-bottom: 20px;
	}

	.gallery ul {
		padding: 0;
		margin: 0;
	}

	.gallery ul:after {
		content: "";
		display: block;
		clear: left;
		height: 0;
	}

	.gallery li {
		display: inline;
		float: left;
	}

	.gallery li div {
		display: inline;
		float: left;
		border: solid #5f5f5f;
		border-width: 1px;
		background-color: #eee;
		padding: 7px;
		margin: 2px 2px 0 0;
		text-align: center;
		position: relative;
		width: <?php echo $thumb_width; ?>px;
		height: <?php echo $thumb_height; ?>px;
	}

	.gallery img {
		border: none;
		vertical-align: bottom;
		/*height: 100%;*/
	}

	.gallery a {
		text-decoration: none;
	}

	.gallery ul a:visited {
		padding: 0;
		background-image: none;
	}

	.gallery a span {
		position: absolute;
		left: -9999px;
		margin: 0;
		padding: 0;
	}

	.gallery a:hover span, .gallery-dir a span {
		top: 0;
		left: 0;
		margin: 0;
		width: 100%;
		font-weight: bold;
		background-color: #eee;
		color: black;
		padding: 5px 0 5px 0;
		font-size: 80%;
		border-bottom: 1px solid #5f5f5f;
		/*
        text-transform: uppercase;
		-moz-opacity: .80;
		opacity: .80;*/
	}
  -->
</style>
</head>
<body>

<?php
    $imgPath = '';

    // get the desired path from the url, and do some basic stipping of possible
    // attempts to access directories outside of the current path
    $path = rawurldecode(str_replace('..', '', $_SERVER['argv'][0]));
    $path = str_replace('//', '/', $path);
    if ($path{0} == '/')
        $path = substr($path, 1);

    if (trim($path) == '')
        $path = '.';

    // make sure it's a valid path
    if (!is_dir($path) && !file_exists($path))
        $path = '.';

    // create navigation bits
    $displayPath = '';
    $tmpPath = '';
    $navBits = explode('/', $path);

    if (in_array(substr($navBits[count($navBits)-1], strpos($navBits[count($navBits)-1], '.')+1), $imageTypes))
    {
        $imgPath = $path;
        $imgName = $navBits[count($navBits)-1];
        $path = str_replace($navBits[count($navBits)-1], '', $path);
        array_pop($navBits);
    }

    $up = $navBits;
    array_pop($up);
    $up = implode('/', $up);
    foreach ($navBits as $bit)
    {
        if (empty($bit))
            continue;

        $tmpPath .= $bit.'/';
        if ($bit == '.')
            $bit = 'Home';
        $displayPath .= '<a href="?'.$tmpPath.'">'.$bit.'</a> / ';
    }

    // grab a list of all the files and directories in the path specified
    $dh = opendir($path);
    while (false !== ($filename = readdir($dh)))
        $dir[] = $filename;
    sort($dir);

    $pics = array();
    $dirs = array();

    // go through the list of files and directories and filter into groups of
    // directories to be listed for navigation, and files/images allowed in the
    // imageTypes list.
    for ($i = 0; $i < count($dir); $i++)
    {
        if (($dir[$i] == '..') || ($dir[$i] == '.'))
            continue;

        if (is_dir($path . '/' . $dir[$i]))
            $dirs[] = $dir[$i];
        else
        {
            if (in_array(substr($dir[$i], strpos($dir[$i], '.')+1), $imageTypes) && (strpos($dir[$i], '_nib_') === false))
                $pics[] = $dir[$i];
        }
    }

    // display list of navigable directories, current path and other options
    echo '<div class="top">';

    echo '<div style="float: left;"><b>Sub-galleries:</b> <select style="width: 200px" onchange="selectGallery(this.value);"><option value="">Select...</option>';
    for ($i = 0; $i < count($dirs); $i++)
        echo '<option value="'.$path.'/'.$dirs[$i].'">'.$dirs[$i].'</option>';
    echo '</select>';
    echo '<br /><b>Gallery: ' . $displayPath . '</b></div>';

	if ($_COOKIE['nibpass'] == md5($password))
	{
	    echo '<div style="float: right;" align="right"><form enctype="multipart/form-data" method="post" action="_nib_upload.php">';
	    echo '<b>Upload image:</b> <input type="file" name="newPic" /><br />';
		echo '<b>Create new sub-gallery (optional):</b> <input type="text" name="newPath" style="width:100px" />';
		echo '<input type="hidden" value="'.$path.'" name="currPath" />';
	    echo '<input type="submit" value="Go" />';
		echo '</form></div>';
	}
	else
	{
	    echo '<div style="float: right;" align="right"><form enctype="multipart/form-data" method="post" action="_nib_upload.php">';
	    echo '<b>Login:</b> <input type="password" name="password" /> ';
	    echo '<input type="submit" value="Go" />';
		echo '</form></div>';
	}

    echo '<div style="clear:both"></div></div>';


    if (!empty($imgPath))
        echo '<div class="image"><div class="imageTitle" id="imageTitle">'.$imgName.'</div><img style="" src="'.$imgPath.'" onload="niceScale(this);" onclick="niceScale(this);" /></div>';

    // show thumbnails
    echo '<div class="gallery"><ul>';
    echo '<li class="gallery-dir"><div><a href="?'.$up.'" title="Back"><img src="_nib_folder_back.png" alt="Back" /><span>Back</span></a></div></li>';
    for ($i = 0; $i < count($dirs); $i++)
        echo '<li class="gallery-dir"><div><a href="?'.$path.'/'.$dirs[$i].'" title="'.$dirs[$i].'"><img src="_nib_folder.png" alt="'.$dirs[$i].'" /><span>'.$dirs[$i].'</span></a></div></li>';
    for ($i = 0; $i < count($pics); $i++)
        echo '<li><div><a href="?'.$path.'/'.$pics[$i].'" title="'.$pics[$i].'"><img src="_nib_thumb.php?'.$path.'/'.$pics[$i].'" alt="'.$pics[$i].'" /><span>'.$pics[$i].'</span></a></div></li>';
    echo '</ul></div>';
?>
<div align="right" class="top"><small>Nice Image Browser - <img src="_nib_shrimpworks.png" border="0" align="absmiddle"/> <a href="http://shrimpworks.za.net/">by ShrimpWorks</a></small></div>
</body>
</html>