<?php
    // basic 'live' thumbnail script
    // by Kenneth "Shrimp" Watson -- http://shrimpworks.za.net/
    // May 2006
    
    // expects $_SERVER['argv'][0] to be an image filename
    // eg. thumb.php?mypic.png

	include('_nib_config.php');

    // get the desired file from the url, and do some basic stipping of possible
    // attempts to access directories outside of the current path
    $filename = rawurldecode(str_replace('..', '', $_SERVER['argv'][0]));
    if ($filename{0} == '/')
        $filename = substr($filename, 1);
    $type = substr($filename, strrpos($filename, '.')+1);

    // GD needs to know what type of file we're trying to open
    // let's assume the basics of jpeg, png, or gif
    if (strtolower($type{0}) == 'j')
    	$image = imagecreatefromjpeg($filename);
    else if (strtolower($type{0}) == 'p')
    	$image = imagecreatefrompng($filename);
    else if (strtolower($type{0}) == 'g')
    	$image = imagecreatefromgif($filename);
    
    // get the original image dimensions
    $width = imagesx($image);
    $height = imagesy($image);
    $thumb = $image;

	if (($width > $thumb_width) || ($height > $thumb_height))
	{
		// only attempt to rescale if the original is bigger than the thumnail size
		if ($width > $thumb_width)
		{
			$scale = $thumb_width / $width;
			// create a new image, the size of the thumbnail
			$thumb = imagecreatetruecolor($thumb_width, $height*$scale);
			// copy the original image onto the thumbnail, scaling it down
			imagecopyresampled($thumb, $image, 0, 0, 0, 0, $thumb_width, $height*$scale, $width, $height);
		}

		$width = imagesx($thumb);
		$height = imagesy($thumb);
		if ($height > $thumb_height)
		{
			$scale = $thumb_height / $height;
			// create a new image, the size of the thumbnail
			$thumb2 = imagecreatetruecolor($width*$scale, $thumb_height);
			// copy the original image onto the thumbnail, scaling it down
			imagecopyresampled($thumb2, $thumb, 0, 0, 0, 0, $width*$scale, $thumb_height, $width, $height);
			$thumb = $thumb2;
		}
	}
//	else
//        $thumb = $image;

    // helps the browser cache the thumbnail image
	header("Last-Modified: " . gmdate('D, d M Y H:i:s', filemtime($filename)) . ' GMT');

    // again, we need to know the type of original image
    // this could actually be done with only one of the following options
    // (jpeg might be most efficient), as the thumbnail is not bound to the
    // original's file type, but i like to dump out the image the same
    // format we received it in
    if (strtolower($type{0}) == 'j')
    {
        header('Content-type: image/jpeg');
    	imagejpeg($thumb);
    }
    else if (strtolower($type{0}) == 'p')
    {
        header('Content-type: image/png');
    	imagepng($thumb);
    }
    else if (strtolower($type{0}) == 'g')
    {
        header('Content-type: image/gif');
    	imagegif($thumb);
    }
?>